
#ifndef 		_HT8_H_
#define 		_HT8_H_

/*---------- Includes MCU -----------------------------------------------------------*/
#include    "ht66f019.h"

#include		"typedef.h"

/*---------- System Clock Configurations --------------------------------------------*/
#define		FSYS4MHZ 			0						/* system clock = 4MHZ */
#define		FSYS8MHZ			1						/* system clock = 8MHZ */
#define		FSYS12MHZ			2						/* system clock = 12MHZ */

#define		SYSTEM_CLOCK		FSYS8MHZ

/*---------- Memory addressing pointer --------------------------------------------*/
#define		IND_ADDR_RESG0		_iar0
#define		IND_ADDR_RESG1		_iar1
#define		MEMORY_POINT0L		_mp0
#define		MEMORY_POINT0H		_bp
#define		MEMORY_POINT1L		_mp1
#define		MEMORY_POINT1H		_bp

/*---------- BC5602 Interface I/O define---------------------------------------------*/
#define		SPI_CSN				_pb5
#define		SPI_SCK				_pb6
#define		SPI_SDO				_pa1
#define		SPI_SDI				_pa3
#define		IRQ_STATUS			_pb0

#define		SPI_CSN_LOW			(_csen=1)
#define		SPI_CSN_HIGH		(_csen=0)

#define		_SPIC0_				_simc0
#define		_SPIC2_				_simc2
#define		_SPIDR_				_simd
#define		_SPIEN_				_simen
#define		_SPIMPL_				_mp1
#define		_SPIMPH_				_bp
#define		_SPIIAR_				_iar1

/*---------- Radio Timer define -----------------------------------------------------*/
#define	_TMC0_			_stmc0
#define	_TMC1_			_stmc1
#define	_TMAL_			_stmal
#define	_TMAH_			_stmah
#define	_TMON_			_ston
#define	_TMIE_			_stmae
#define	_TMIF_			_stmaf
#define	_TMMFIE_			_mf0e
#define	_TMMFIF_			_mf0f
#define	_TMISRADDR_		0x0C
/*---------- BUTTON Interface I/O define---------------------------------------------*/
#define  BUTTON1_IN		_pa6
#define  BUTTON2_IN		_pa5
#define  BUTTON3_IN		_pa4

/*---------- LED Interface I/O define------------------------------------------------*/
#define  LED1O				_pb4
#define  LED2O				_pb3
#define  LED3O				_pa7

#endif		/* _HT8_H_ */
